#ifndef __AGENT_H__
#define __AGENT_H__
#include <stdio.h>

#include "global.h"
#include "attribute.h"

#define ATTR_INT	TYPE_INT
#define ATTR_BOOL	TYPE_BOOL
#define ATTR_SET	TYPE_SET
#define ATTR_HASH	TYPE_HASH
#define ATTR_RANDOM	(1<<16)


typedef struct S_AGENTCLASS{
	long class_handle;
	char * class_name;
	ATTRIBUTE_PARAM *attr_params;
	} AGENTCLASS;
	
typedef struct S_AGENT{
	long class_handle;
	u64 *attribute;
	} AGENT;	


void init_agents(void);
void reset_agentclasses(void);
AGENT * alloc_agent(AGENTCLASS *ac);
void  free_agent(AGENT *a);
AGENT * make_agent(AGENTCLASS *ac);
AGENTCLASS * add_new_agentclass(char *name);
AGENTCLASS * get_agentclass(char *name);
AGENTCLASS * get_agentclass_from_handle(long h);
AGENT *dup_agent(AGENT *a);
void remove_attribute(AGENTCLASS *ac,int j);
long get_max_class_handle(void);
//void add_attribute(AGENTCLASS *ac, char *name, u64 type, u64 value);
char * attr_type_name(long l);
void dump_agent(FILE *fout, AGENT *a);
void dump_classes(FILE *fout);
int get_attribute_value(AGENT *a, long attribute,u64 *result);
int set_agentclass_attr_param_value(AGENTCLASS *ac, char *attr_name,ATTRIBUTE_PARAM *p);
#endif
